<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage helpers
* @filesource
*/
function purify($dirty_html)
{

     if (is_array($dirty_html))
    {
        foreach ($dirty_html as $key => $val)
        {
            $dirty_html[$key] = purify($val);
        }

        return $dirty_html;
    }
	if(string_length_in_bytes($dirty_html) >= 2097152) {
		$return_value = 'HTML text too long to process (greater than 2 MB), raw HTML provided below:<br /><br />';
		$return_value = $return_value . htmlspecialchars($dirty_html);
		return $return_value;
	}
    if (trim($dirty_html) === '')
    {
        return $dirty_html;
    }

    require_once(APPPATH."third_party/HTMLPurifier.standalone.php"); 

    $config = HTMLPurifier_Config::createDefault();
	$config->set('Core.Encoding', 'utf-8');
    $config->set('HTML.Doctype', 'XHTML 1.0 Strict');
    $purifier = new HTMLPurifier($config);
	return $purifier->purify($dirty_html);
}